/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package tu41mc;

import com.cinterion.io.ATCommand;
import com.cinterion.io.ATCommandFailedException;

/**
 *
 * @author nshulgina
 */
public class LedThread extends Thread {
    private ATCommand atCommand;
    private final int sleep = 1000;
    private boolean was3g = false;
    private int wasCsq = -1;
    private boolean wasSimIns = false;
    private int wasSimReg = 0;
    
    
    public LedThread(ATCommand atCommand) {
        this.atCommand = atCommand;        
    }
    
    public void run() {
        boolean first = true;
        
        while (true) {
            try {
                Thread.sleep(sleep);
            } catch (InterruptedException ex) {}
            
            try {
                int nowCsq = 0;
                
                String ans = atCommand.send("AT^SMONI\r");
                //IMlet.log(ans);
                boolean now3g = ans.toLowerCase().indexOf("^smoni: 3g,") > -1 && ans.toLowerCase().indexOf(",search") < 0;
                ans = atCommand.send("AT+CSQ\r");
                //IMlet.log(ans);
                
                if (ans.indexOf("CSQ: ") > -1) {
                    try {
                        nowCsq = Integer.parseInt(ans.substring((ans.indexOf("CSQ: ") + 5), ans.indexOf(",")));
                        if (nowCsq < 16 || nowCsq == 99) {
                            nowCsq = 2;
                        } else if (nowCsq < 23) {
                            nowCsq = 1;
                        } else {
                            nowCsq = 0;
                        }
                    } catch (NumberFormatException ex) {}
                }

                if (first || was3g != now3g || nowCsq != wasCsq) {
                    IMlet.log("signal changed. 3g: " + now3g + ", csq: " + nowCsq);
                    IMlet.changedSignal(now3g, nowCsq);                
                    was3g = now3g;
                    wasCsq = nowCsq;                    
                }
                
                ans = atCommand.send("AT+CCID\r").toLowerCase();
                boolean nowSimIns = ans.indexOf("error") < 0 && ans.indexOf("+ccid: ") > -1;
                ans = atCommand.send("AT+CREG?\r").toLowerCase();
                int nowReg = 0;
                if (ans.indexOf("error") < 0 && ans.indexOf("+creg: ") > -1) {
                    ans = ans.substring(ans.indexOf(",")+1);
                    ans = ans.substring(0, 1);
                    if (ans.equals("1")) {
                        nowReg = 1;
                    } else if (ans.equals("5")) {
                        nowReg = 2;
                    }
                }
                if (first || nowSimIns != wasSimIns || nowReg != wasSimReg) {
                    IMlet.log("sim state changed. inserted: " + nowSimIns + ", registered: " + nowReg);
                    IMlet.simInfoChanged(nowSimIns, nowReg);
                    first = false;
                    wasSimIns = nowSimIns;
                    wasSimReg = nowReg;
                }                
            } catch (ATCommandFailedException ex) {}
        }
        
    }
    
}
